require( "scripts/style.lua" );

SliderFont = {
  standardFont,
  26,
  BlackColor
};


MakeDialog
{
    -- Name the modal dialog
    name="optionsmenu",
    Bitmap
    {
        name="grayimage",
        image="backgrounds/shadow.png",
        alpha=true,
        x=0,
        y=0
    };
    Bitmap
    {
        image="backgrounds/options",
        x = kCenter,
        y = kCenter,
        w=598,
        h=541,
        
        OptionsWindow
        {
            x=0,y=0,w=kMax,h=kMax,
            
            Text
            {
                font = SliderFont,
                name = "sfx",
                x=140,y=110,w=200,h=50,
                --flags = kHAlignCenter + kVAlignCenter,
                label = "sfxlevel"
            };
        
            Text
            {
                font = SliderFont,
                name = "music",
                x=140,y=210,w=200,h=50,
                --flags = kHAlignCenter + kVAlignCenter,
                label = "musiclevel"
            };

            SetStyle(CheckboxButtonStyle),          
            Button{
                name="fullscreen",
                x=140,
                y=310,
                w=150,
                Text
                {
                    font = StandardButtonFont,
                    name = "fullscreenlabel",
                    x=54,
                    y=0,
                    w=kMax,
                    h=kMax,
                    flags = kHAlignLeft + kVAlignTop,
                    label="fullscreen",
                };
                command=
                function()
                    if (ToggleFullScreen() == false) then
                        DisplayDialog { 
                            "scripts/ok.lua", 
                            body ="screenswitchfailed",
                            title = "playground" 
                        };
                    end
                end
                
            };
            
            Button{
                name="mutebox",
                x=315,
                y=310,
                w=175,
                Text
                {
                    font = StandardButtonFont,
                    name = "mutesoundlabel",
                    x=54,
                    y=0,
                    w=kMax,
                    h=kMax,
                    flags = kHAlignLeft + kVAlignTop,
                    label="mutesound",
                };
                command =
                    function()
                        ToggleSoundMute();
                    end
            };

            SetStyle(ButtonStyle),
            Button
            {
                x=140, y=395,
                graphics = StButtonGraphicsSm,
                font = MenuButtonFont;
                name="back",
                label="back",
                type = kPush,
                command =
                    function()
                        SaveVolumes();
                        PopModal("optionsmenu");
                    end
            },
            
            Button
            {
                x=335, y=395,
                graphics = StButtonGraphicsSm,
                font = MenuButtonFont;
                name="credits",
                label="credits",
                type = kPush,
                command =
                    function()
                        DoModal("scripts/credits.lua");
                    end
            },
            Bitmap
            {
                name="sl_left1",
                image="slider/nail_l.png",
                x=140,
                y=145,
            },
            Bitmap
            {
                name="sl_right1",
                image="slider/nail_r.png",
                x=430,
                y=145,
            },
            Bitmap
            {
                name="sl_left2",
                image="slider/nail_l.png",
                x=140,
                y=245,
            },
            Bitmap
            {
                name="sl_right2",
                image="slider/nail_r.png",
                x=430,
                y=245,
            },

            SetStyle(SliderStyle),
            Slider
            {
                name="sfxlevelslider",
                x = 160,
                y = 150,
                w = 270,
            };
            
            Slider
            {
                name="musiclevelslider",
                x = 160,
                y = 250,
                w = 270,
            };
        },
    },
}

SetImageAlpha("grayimage",0.4);
